<?php

namespace WireElements\Pro;

use Livewire\Features\SupportConsoleCommands\Commands\UpgradeCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class WireElementsProServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('wire-elements-pro')
            ->hasConfigFile()
            ->hasAssets()
            ->hasViews()
            ->hasTranslations();
    }

    public function bootingPackage()
    {
        if(class_exists(Livewire\Features\SupportConsoleCommands\Commands\UpgradeCommand::class)) {
            UpgradeCommand::addThirdPartyUpgradeStep(WireElementsProUpgrade::class);
        }
    }
}
